package org.bm.p2p.navigablep2p;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.Logger;
import org.bm.p2p.navigablep2p.test.Log4jExample;

public class Graph {
	static Logger logger = Logger.getLogger(Graph.class.getName());
	private ArrayList<Node> nodes;

	public ArrayList<Node> getNodes() {
		return nodes;
	}

	public void setNodes(ArrayList<Node> nodes) {
		this.nodes = nodes;
	}

	// ʼ磬ڵΪ0
	public Graph() {
		super();
		nodes = new ArrayList<Node>();
	}

	// ʼ磬ڵΪsizeڵ֮ûб߽
	public Graph(int size) {
		super();
		nodes = new ArrayList<Node>();
		for (int i = 0; i < size; i++) {
			System.out.print(i + ": ");
			nodes.add(new Node());
		}
	}

	// ģBootStrapƣоѡһڵ㷵
	public Node bootstrap() {
		Random random = new Random();
		if (nodes.size() > 0) {
			int chosedNodeIdx = random.nextInt(nodes.size());
			return nodes.get(chosedNodeIdx);
		}
		return null;
	}

	// ʼĵһڵ
	public void initializeTheFirstNode(Node node) {
		nodes.add(node);
	}

	// ڵnode, ͵Ϣ
	public int addNode5(Node node) {
		int maxDepth = Node.BUCKETS;
		int messageNum = 0;
		// ϵڵ
		Node bootstrapNode = bootstrap();

		class Message {
			Node srcNode;
			Node nowNode;
			int depth;

			Message(Node srcNode, Node nowNode, int depth) {
				this.srcNode = srcNode;
				this.nowNode = nowNode;
				this.depth = depth;
			}
		}

		Queue<Message> visitedNodes = new LinkedList<Message>();
		Message visitedNode;
		for (int i = 0; i < Node.BUCKETS; i++) {
			if (bootstrapNode.getNeighbor(i) != null) {
				ArrayList<Node> tt = bootstrapNode.getNeighbors(i);
				if (tt.size()>0)
					for (int j=0;j<tt.size();j++){
						visitedNode = new Message(node, tt.get(j), 0);
						visitedNodes.add(visitedNode);
					}
			}
		}

		node.setNeighbor(bootstrapNode, node.getDistanceFrom(bootstrapNode));
		bootstrapNode.setNeighbor(node, node.getDistanceFrom(bootstrapNode));
		int distance;
		while (visitedNodes.size() > 0) {
			visitedNode = visitedNodes.remove();
			messageNum++;
			Node srcNode = visitedNode.srcNode;
			Node nowNode = visitedNode.nowNode;

			distance = srcNode.getDistanceFrom(nowNode);
			// logger.info(messageNum+"th node, position = "+visitedNode.nowNode.getNodePosition());
			if (visitedNode.depth <= maxDepth) {
					Random random = new Random();
					int randomNum = random.nextInt((int) Math.pow(2, (Node.BUCKETS
							- distance + 1)) - 3);
					if (randomNum < 1) { // 
						ArrayList<Node> nextNodes = new ArrayList<Node>();
						for (int i = distance + 1; i < Node.BUCKETS; i++) {
							if (nowNode.getNeighbor(i) != null
									&& nowNode.getNeighbor(i) != srcNode)
								nextNodes.add(nowNode.getNeighbor(i));
						}
						if (nextNodes.size() > 0) {
							Random random2 = new Random();
							int chosedIdx = random2.nextInt(nextNodes.size());
							Message message = new Message(srcNode, nextNodes
									.get(chosedIdx), visitedNode.depth + 1);
							visitedNodes.add(message);
						}

					} else if (randomNum < (int) Math.pow(2,
							(Node.BUCKETS - distance) - 1)) { // 
						if (nowNode.getNeighbor(distance) != null
								&& nowNode.getNeighbor(distance) != srcNode) {
							Message message = new Message(srcNode, nowNode
									.getNeighbor(distance), visitedNode.depth + 1);
							visitedNodes.add(message);
						}

					} else { // С
						ArrayList<Node> nextNodes = new ArrayList<Node>();
						for (int i = distance - 1; i >= 0; i--) {
							if (nowNode.getNeighbor(i) != null
									&& nowNode.getNeighbor(i) != srcNode)
								nextNodes.add(nowNode.getNeighbor(i));
						}
						if (nextNodes.size() > 0) {
							Random random2 = new Random();
							int chosedIdx = random2.nextInt(nextNodes.size());
							Message message = new Message(srcNode, nextNodes
									.get(chosedIdx), visitedNode.depth + 1);
							visitedNodes.add(message);
						}

					
				}
			}
			 if (nowNode.getNeighbor(distance)!=null) {
			srcNode.setNeighbor(nowNode, distance);
			nowNode.setNeighbor(srcNode, distance);
			 }
			 else {
			 routingToAllNodesLessthanDistance2(srcNode,nowNode,distance-1);
			 }
			// ھҲӽȥ

		}

		nodes.add(node);
		return messageNum;
	}

	// ҺͽڵnodeľСڵdistanceнڵ()
	public int routingToAllNodesLessthanDistance2(Node srcNode, Node node,
			int distance) {
		class NodeAndDistance {
			Node node;
			int distance;

			NodeAndDistance(Node node, int distance) {
				this.node = node;
				this.distance = distance;
			}
		}
		;
		int numth = 0;
		Queue<NodeAndDistance> visitedNodes = new LinkedList<NodeAndDistance>();
		NodeAndDistance visitedNode = new NodeAndDistance(node, distance);
		visitedNodes.add(visitedNode);
		while (visitedNodes.size() > 0) {
			visitedNode = visitedNodes.remove();
			numth++;
			// visit node
			srcNode.setNeighbor(visitedNode.node, distance + 1);
			visitedNode.node.setNeighbor(srcNode, distance + 1);
			logger.info(numth + "th node, position = "
					+ visitedNode.node.getNodePosition());
			for (int i = 0; i <= visitedNode.distance; i++) {
				if (visitedNode.node.getNeighbor(i) != null) {
					NodeAndDistance nextNode = new NodeAndDistance(
							visitedNode.node.getNeighbor(i), i - 1);

					visitedNodes.add(nextNode);
				}
			}
		}
		return numth;
	}

	// ҺͽڵnodeľСڵdistanceнڵ
	public int routingToAllNodesLessthanDistance(Node node, int distance,
			int numth) {
		// 
		int i;
		for (i = 0; i < Node.BUCKETS; i++)
			if (node.getNeighbor(i) != null)
				break;
		if (distance < i)
			return numth - 1;
		logger.info(numth + "th node, distance = " + distance + " position = "
				+ node.getNodePosition());
		Node rightNode = node.getNeighbor(distance);
		if (rightNode != null && rightNode != node)
			numth += routingToAllNodesLessthanDistance(rightNode, distance - 1,
					numth + 1);
		// Node leftNode = node.getNeighbor(distance-1);
		// if (leftNode != null&&leftNode!=node)

		numth += routingToAllNodesLessthanDistance(node, distance - 1,
				numth + 1);
		return numth;
	}

	// ѽڵbootstrapھӽڵڵnode
	public void addNodeNeighbors(Node node, Node bootstrapNode) {
		// bootstrapڵھӼ뵽ڵھ
		int distance = node.getDistanceFrom(bootstrapNode);
		node.setNeighbor(bootstrapNode, distance);
		bootstrapNode.setNeighbor(node, distance);

		// distanceھ
		for (int j = distance + 1; j < Node.BUCKETS; j++) {
			if (bootstrapNode.getNeighbors(j).size() > 0) {
				for (int k = 0; k < bootstrapNode.getNeighbors(j).size(); k++) {
					node.setNeighbor(bootstrapNode.getNeighbors(j).get(k), j);
					bootstrapNode.getNeighbors(j).get(k).setNeighbor(node, j);
				}
			}
		}
		// Сdistanceھ
		for (int j = distance - 1; j >= 0; j--) {
			if (bootstrapNode.getNeighbors(j).size() > 0) {
				for (int k = 0; k < bootstrapNode.getNeighbors(j).size(); k++) {
					node.setNeighbor(bootstrapNode.getNeighbors(j).get(k),
							distance);
					bootstrapNode.getNeighbors(j).get(k).setNeighbor(node,
							distance);
				}
			}
		}
		// distanceھ
		if (bootstrapNode.getNeighbors(distance).size() > 0) {
			for (int k = 0; k < bootstrapNode.getNeighbors(distance).size(); k++) {
				if (node.getDistanceFrom(bootstrapNode.getNeighbors(distance)
						.get(k)) >= 0) {
					node.setNeighbor(bootstrapNode.getNeighbors(distance)
							.get(k), node.getDistanceFrom(bootstrapNode
							.getNeighbors(distance).get(k)));
					bootstrapNode.getNeighbors(distance).get(k).setNeighbor(
							node,
							node.getDistanceFrom(bootstrapNode.getNeighbors(
									distance).get(k)));
				}
			}
		}
	}

	// ڵ㣺ѡȡBUCKETSڵ㣬ǵھӼ뵽ڵھ
	public int addNode3(Node node) {
		Node bootstrapNode = bootstrap(); // bootstrapڵ
		for (int i = 0; i < Node.BUCKETS; i++) {
			addNodeNeighbors(node, bootstrapNode);
			Random random = new Random();
			int chosedIdx = random.nextInt(bootstrapNode.BUCKETS);
			while (bootstrapNode.getNeighbor(chosedIdx) == null)
				chosedIdx = random.nextInt(bootstrapNode.BUCKETS);
			bootstrapNode = bootstrapNode.getNeighbor(chosedIdx);
		}
		nodes.add(node);
		return 1;
	}

	public int addNode4(Node node) {
		int messageNum = 0;

		Node bootstrapNode = bootstrap(); // bootstrapڵ
		int distance = node.getDistanceFrom(bootstrapNode);
		if (distance >= 0) {
			node.setNeighbor(bootstrapNode, distance);
			bootstrapNode.setNeighbor(node, distance);
		}
		for (int i = 0; i < Node.BUCKETS; i++) {
			// bootstrapNode = bootstrap(); // bootstrapڵ
			// һͽڵnodeľΪi½ڵrandomDestNode
			Node srcNode = bootstrapNode;
			Node randomDestNode = new Node(node, i);
			// logger.info("node: "+node.getNodePosition()+
			// " randomdestNode: "+randomDestNode.getNodePosition()+" distance = "+i);
			while (srcNode != randomDestNode && srcNode != null) {
				srcNode = srcNode.getNeighbor(srcNode
						.getDistanceFrom(randomDestNode));
				if (srcNode != null) {
					distance = node.getDistanceFrom(srcNode);
					if (distance >= 0) {
						addNodeNeighbors(node, srcNode);
						// node.setNeighbor(srcNode, distance);
						// srcNode.setNeighbor(node, distance);
					}
				}
			}
		}
		nodes.add(node);
		return messageNum;
	}

	// ڵnode跢͵Ϣ
	public int addNode2(Node node) {
		int messageNum = 0; // һڵ跢͵Ϣ
		for (int i = 0; i < Node.BUCKETS; i++) {
			// һͽڵnodeľΪi½ڵrandomDestNode
			// Node randomDestNode = new Node(node,i);
			// ڵrandomDestNodeΪĿڵ㣬bootstrapNodeʼ·ɵrandomDestNode
			// мڵڵnodeĳھӣڵnodeЩмڵھ
			// мڵΪգмڵھѾڣ
			// Ѿ֪ĳڵھӺͳھӣͿڵھӺͳھӵľ

			Node bootstrapNode = bootstrap(); // bootstrapڵ
			int maxDestNodeNum = (int) Math.pow(2, Node.BUCKETS / (i + 1)); // ÿηĿڵ
			// ϵڵbootstrapNodeʼڵnodeľΪiĽڵ
			// ϵڵbootstrapNodeͼڵľi
			while ((bootstrapNode != null)
					&& (node.getDistanceFrom(bootstrapNode) > i)) {
				// node.setNeighbor(bootstrapNode,
				// node.getDistanceFrom(bootstrapNode));

				bootstrapNode = bootstrapNode.getNeighbor(node
						.getDistanceFrom(bootstrapNode));
				// bootstrapNode.setNeighbor(node,
				// node.getDistanceFrom(bootstrapNode));
				messageNum++;
			}
			if ((bootstrapNode != null)
					&& (node.getDistanceFrom(bootstrapNode) < i)) {
				// node.setNeighbor(bootstrapNode,
				// node.getDistanceFrom(bootstrapNode));
				// bootstrapNode.setNeighbor(node,
				// node.getDistanceFrom(bootstrapNode));
				bootstrapNode = bootstrapNode.getNeighbor(i);
				messageNum++;
			}
			if ((bootstrapNode != null)
					&& (node.getDistanceFrom(bootstrapNode) == i)) { // ϵڵͼڵľ=i
				// кϵڵľСiĽڵ㣬Щڵͼڵľ붼i
				// һȵ㷨
				Queue<Node> visitedNodes = new LinkedList<Node>();
				visitedNodes.add(bootstrapNode); // ϵڵѷʽڵ
				int destNodeNum = 0; // ѷʵĽڵ
				// ֻҪѷʽڵûдﵽmaxDestNodeNumңѷʽڵвΪ
				while ((destNodeNum <= maxDestNodeNum)
						&& (visitedNodes.size() > 0)) {
					// ѷʽڵȡһڵ
					Node hasVisitedNode = visitedNodes.remove();
					// ýڵľΪiĳھΪգͰѼڵnodeΪýڵΪiĳھ
					if (hasVisitedNode.getNeighbor(i) == null) {
						hasVisitedNode.setNeighbor(node, i);
						node.setNeighbor(hasVisitedNode, i);
						// maxDestNodeNum = 10000;
					}
					// ýڵΪڵnodeĳھ
					node.setNeighbor(hasVisitedNode, i);
					hasVisitedNode.setNeighbor(node, i);

					// ִstolen
					// linkhasVisitedNodeһھӽڵ㣬ڵʱԽھԽࡱ
					// for (int k = i+1; k < Node.BUCKETS; k++) {
					// if (hasVisitedNode.getInNeighbor(k)!=null) {
					// hasVisitedNode.getInNeighbor(k).setOutNeighbor(node, k);
					// node.setInNeighbor(hasVisitedNode.getInNeighbor(k), k);
					// }
					// }

					destNodeNum++;
					messageNum++;
					// ʺͽڵhasVisitedNodeľСiнڵ
					for (int j = i - 1; j >= 0; j--) {
						if (hasVisitedNode.getNeighbor(j) != null) {
							visitedNodes.add(hasVisitedNode.getNeighbor(j));
						}
					}

				}

			}
		}
		nodes.add(node);
		return messageNum;
	}

	// ɾڵ㣬跢͵Ϣ
	// ɾڵھӽڵĳھñɾڵĳھ
	public int delNode(Node node) {
		int messageNum = 0;
		// ɾڵھӽڵбеھ
		int j = 0;
		for (int i = 0; i <= Node.BUCKETS - 1; i++) {
			if (node.getNeighbor(i) != null) {
				for (int k = j; k <= i; k++) {
					if (node.getNeighbor(k) != null) {
						node.getNeighbor(i).setNeighbor(node.getNeighbor(k), i);
						messageNum++;
						break;
					}
				}
				j = i;
			}
		}
		return messageNum;
	}

	public void delNodes() {
		for (int i = 0; i < nodes.size(); i++) {
			Random random = new Random();
			int chosenNodeIdx = random.nextInt(nodes.size());
			int messageNum = delNode(nodes.get(chosenNodeIdx));
			System.out.println("delNode messageNum: " + messageNum);
			nodes.remove(chosenNodeIdx);
			testRoute();
		}
	}

	/**
	 * ڵnode磬ʹRandom WalkΪڵnodeӱ
	 * 
	 * ڵaһھӽڵbڵcǽڵbĳھӽڵ㣬ô (1) If D(b,c)=D(a,b), Then D(a,c)<D(a,b)
	 * (2) If D(b,c)>D(a,b), Then D(a,c)=D(b,c)>D(a,b) (3) If D(b,c)<D(a,b),
	 * Then D(a,c)=D(a,b)
	 * 
	 * ͨ»ƻNextHops: (1): ԽڵcΪNextHop (2): ѡڵcΪNextHop (3):
	 * ڵ룬ֹͣ
	 */
	/*
	 * public void addNode(Node node) { Node bootstrapNode = bootstrap(); //
	 * bootstrapڵ //int maxSteps = Node.BUCKETS; // ? int maxDistance =
	 * Node.BUCKETS-1, minDistance = 0; int messageNumber =
	 * randomWalk(maxDistance, minDistance, node, bootstrapNode, 0);
	 * System.out.println("messages: " + messageNumber); nodes.add(node); }
	 * 
	 * private int randomWalk(int maxDistance, int minDistance, Node joinNode,
	 * Node concactNode, int messageNumber) { if (messageNumber++ > MAXMESSAGES)
	 * return messageNumber;
	 * 
	 * // üڵϵڵľ int curDistance =
	 * joinNode.getDistanceFrom(concactNode); // 洢 ϵڵھ ڵľ
	 * ϵڵڵľ ȵĽڵ ArrayList<Node> distanceEqualsNodes = new
	 * ArrayList<Node> (); // ϵڵ distanceEqualsNodes.add(concactNode); //
	 * ϵڵھеͬڵ for (int i = curDistance - 1; i>=0;i--) { if
	 * (concactNode.getOutNeighbor(i) != null)
	 * distanceEqualsNodes.add(concactNode.getOutNeighbor(i)); } //
	 * ͬڵбѡһڵ Random random = new Random(); int chosedNodeIdx =
	 * random.nextInt(distanceEqualsNodes.size()); //ýڵ뵽ڵھӽڵ
	 * joinNode.setOutNeighbor(distanceEqualsNodes.get(chosedNodeIdx),
	 * curDistance); //ҪҪڵýڵھأ
	 * distanceEqualsNodes.get(chosedNodeIdx).setOutNeighbor(joinNode,
	 * curDistance);
	 * 
	 * //ѡһڵ㣬ڵСcurDistanceĽڵ㣨ֻһ Node distanceLessNode =
	 * concactNode.getOutNeighbor(curDistance); if (distanceLessNode!=null &&
	 * !distanceLessNode.equals(joinNode)) { // &&
	 * joinNode.getDistanceFrom(distanceLessNode) >= minDistance messageNumber =
	 * randomWalk(maxDistance, minDistance, joinNode, distanceLessNode,
	 * messageNumber); //curDistance-1 }
	 * 
	 * //ѡһڵ㣬ڵcurDistanceĽڵ ArrayList<Node> distanceLargerNodes =
	 * new ArrayList<Node> (); for (int i = curDistance + 1; i <=
	 * maxDistance;i++) { if (concactNode.getOutNeighbor(i) != null)
	 * distanceLargerNodes.add(concactNode.getOutNeighbor(i)); } if
	 * (distanceLargerNodes.size()>0) { random = new Random(); chosedNodeIdx =
	 * random.nextInt(distanceLargerNodes.size()); messageNumber =
	 * randomWalk(maxDistance,minDistance , joinNode,
	 * distanceLargerNodes.get(chosedNodeIdx), messageNumber); //curDistance+1 }
	 * return messageNumber; }
	 * 
	 * private int randomWalk2(int maxDistance, int minDistance, Node joinNode,
	 * Node concactNode, int messageNumber) { if (messageNumber++ > MAXMESSAGES)
	 * return messageNumber;
	 * 
	 * // üڵϵڵľ int curDistance =
	 * joinNode.getDistanceFrom(concactNode); // 洢 ϵڵھ ڵľ
	 * ϵڵڵľ ȵĽڵ ArrayList<Node> distanceEqualsNodes = new
	 * ArrayList<Node> (); // ϵڵ distanceEqualsNodes.add(concactNode); //
	 * ϵڵھеͬڵ for (int i = curDistance - 1; i>=0;i--) { for (int j =
	 * 0; j < Node.K; j++) { if (concactNode.getOutNeighborByIdx(i,j) != null)
	 * distanceEqualsNodes.add(concactNode.getOutNeighborByIdx(i,j)); } } //
	 * ͬڵбѡKڵ if (distanceEqualsNodes.size()>Node.K) { for (int i =
	 * 0; i < Node.K; i++) { Random random = new Random(); int chosedNodeIdx =
	 * random.nextInt(distanceEqualsNodes.size());
	 * //ýڵ뵽ڵھӽڵ(ܳͬĽڵ!)
	 * joinNode.setOutNeighbor(distanceEqualsNodes.get(chosedNodeIdx),
	 * curDistance); //ҪҪڵýڵھأ
	 * distanceEqualsNodes.get(chosedNodeIdx).setOutNeighbor(joinNode,
	 * curDistance); } } else { for (int i = 0; i < distanceEqualsNodes.size();
	 * i++) { //ýڵ뵽ڵھӽڵ(ܳͬĽڵ!) if
	 * (!joinNode.equals(distanceEqualsNodes.get(i))) {
	 * joinNode.setOutNeighbor(distanceEqualsNodes.get(i), curDistance);
	 * //ҪҪڵýڵھأ
	 * distanceEqualsNodes.get(i).setOutNeighbor(joinNode, curDistance);
	 * 
	 * } } }
	 * 
	 * //ѡһڵ㣬ڵСcurDistanceĽڵ㣨ֻһ for (int i = 0; i < Node.K;
	 * i++) { Node distanceLessNode =
	 * concactNode.getOutNeighborByIdx(curDistance,i); if
	 * (distanceLessNode!=null && !distanceLessNode.equals(joinNode)) { // &&
	 * joinNode.getDistanceFrom(distanceLessNode) >= minDistance messageNumber =
	 * randomWalk2(maxDistance, minDistance, joinNode, distanceLessNode,
	 * messageNumber); //curDistance-1 } }
	 * 
	 * //ѡһڵ㣬ڵcurDistanceĽڵ
	 * 
	 * ArrayList<Node> distanceLargerNodes = new ArrayList<Node> (); for (int i
	 * = curDistance + 1; i <= maxDistance;i++) { for (int j = 0; j < Node.K;
	 * j++) { if (concactNode.getOutNeighborByIdx(i,j) != null)
	 * distanceLargerNodes.add(concactNode.getOutNeighborByIdx(i,j)); } } if
	 * (distanceLargerNodes.size()>0) { //Random random = new Random();
	 * //chosedNodeIdx = random.nextInt(distanceLargerNodes.size()); for (int i
	 * = 0; i < distanceLargerNodes.size() ;i++) { messageNumber =
	 * randomWalk2(maxDistance,minDistance , joinNode,
	 * distanceLargerNodes.get(i), messageNumber); //curDistance+1 } } return
	 * messageNumber; }
	 */

	// ΪӱߣKlernbergNavigable Networkģ(ʽ㷨)
	public void addEdgesAccordingToDistance() {
		ArrayList<Node> someNodes = new ArrayList<Node>();
		for (Node node : nodes) { // ÿڵ
			for (int i = 0; i < Node.BUCKETS; i++) { // ΪýڵÿͰһھӽڵ
				someNodes.clear();
				for (Node node2 : nodes) { // ڵѡȡýڵΪiĽڵ㼯
					// ڵ㲻ȣҽڵΪi
					if (!node.equals(node2)
							&& (node.getDistanceFrom(node2) == i)) {
						someNodes.add(node2);
					}
				}
				if (someNodes.size() > 0) { // ڵ㼯ϲΪ
					// System.out.print(i + " ");
					// ӾΪiĽڵ㼯ѡȡһڵ(?ģ͸ӦΪ1/2^i)
					Random random = new Random();
					int chosedNodeIdx = random.nextInt(someNodes.size());
					// ѡȡĽڵ뱾ڵھӽڵб
					node.setNeighbor(someNodes.get(chosedNodeIdx), i);// 
																		// (˴Ҳ԰someNodesĳȷڵھӽڵ㣬ܻ·ȵķ)
				}
				// System.out.println();

			}
		}
	}

	// ྶ·,ʵ?
	public int multiPathRoute(Node srcNode, Node destNode, int maxSteps) {
		int steps = 0;

		return steps;
	}

	// ĽڵsrcNode·ɵڵdestNode·ɷν̰·(Greed Routing)
	// steps>0ʾ·ɳɹstepsĴС·,steps=-1ʾж,steps=0ʾmaxSteps
	// ·ͣҲһڵʱ1ʾʧܣ2ʾѡڶһڵ
	public int route(Node srcNode, Node destNode, int maxSteps, int routeType) {
		int steps = 0;
		// СmaxStepsԴڵ㻹ûеĿڵ㣬
		for (steps = 0; steps <= maxSteps && !srcNode.equals(destNode); steps++) {
			// ȡԴڵsrcNodeĿڵľ
			int distance = srcNode.getDistanceFrom(destNode);
			// srcNodeھӽڵиþھӣ
			if (srcNode.getNeighbor(destNode) != null) {
				// ǰھӽڵ
				srcNode = srcNode.getNeighbor(destNode);
			} else { // srcNodeھӽڵûиþھӣ
				if (routeType == 1) { // ·Ϊ1
					// logger.info("route fail, from "+srcNode.getNodePosition()+" to "+
					// destNode.getNodePosition());
					// srcNode.outputNeighbors();
					return -1; // -1ʾ·ʧ
				} else if (routeType == 2) { // ·Ϊ2
					// srcNodeľСdistanceĽڵѡȡһΪһڵ
					ArrayList<Node> distanceLessNodes = new ArrayList<Node>();
					for (int i = distance - 1; i >= 0; i--) {
						if (srcNode.getNeighbor(i) != null)
							distanceLessNodes.add(srcNode.getNeighbor(i));
					}
					if (distanceLessNodes.size() > 0) { // ҵ
						Random random = new Random();
						int nextNodeIdx = random.nextInt(distanceLessNodes
								.size());
						srcNode = distanceLessNodes.get(nextNodeIdx);
					} else { // ûҵsrcNodeľdistanceĽڵѡСĽڵ㣬Ϊһڵ
						int i;
						for (i = distance + 1; i < Node.BUCKETS; i++) {
							if (srcNode.getNeighbor(i) != null)
								srcNode = srcNode.getNeighbor(i);
							break;
						}
						if (i == Node.BUCKETS) // ûҵ·ʧ
							return -1;
					}
				}
			}
		}
		if (steps == -1 || steps > maxSteps) { // ·ʧܴӡlog
			logger.info("route fail, from " + srcNode + " to " + destNode);
			srcNode.outputNeighbors();
		}
		if (steps > maxSteps)
			return 0; // ·ȣ0ʾ·ʧ
		return steps; // 򣬷·
	}

	// ·ܣָ
	// 1··
	// 2·ʧܱ
	public void testRoute() {
		int steps = 0;
		double avgSteps = 0.0; // ƽ·
		double successPercent = 0.0; // ·ɳɹ

		int totalSteps = 0, // ·
		successNumber = 0, // ·ɳɹ
		totalNumber = 0; // ·ɴ
		for (Node srcNode : nodes) { // еÿڵ
			for (Node destNode : nodes) { // 㵽нڵ·
				if (srcNode.equals(destNode))
					continue; // ԴڵĿڵͬһڵ㣬ͽѭ
				steps = route(srcNode, destNode, Node.BUCKETS * Node.BUCKETS, 1);
				// logger.info(steps+" ");

				totalNumber++; // ·ɴ1
				if (steps == 0 || steps == -1) { // ·ʧ
				} else { // ·ɳɹ
					totalSteps += steps; // ·
					successNumber++; // ·ɳɹ1
				}
			}
			// logger.info('\n');
		}
		avgSteps = (double) totalSteps / successNumber; // ƽ· = · /
														// ·ɳɹ
		successPercent = (double) successNumber / totalNumber * 100; // ·ɳɹ =
																		// ·ɳɹ
																		// /
																		// ·ɴ
		logger.info("ƽ· = " + avgSteps);
		logger.info("·ɳɹ = " + successPercent + "%");

	}

	// ṹļ
	public void output(String fileName) {
		PrintWriter fileOutput;
		try {
			fileOutput = new PrintWriter(new BufferedWriter(new FileWriter(
					fileName)));
			// нڵ
			for (int i = 0; i < nodes.size(); i++) {
				Node tmpNode = nodes.get(i);
				fileOutput.print(tmpNode.hashCode() + ", "
						+ tmpNode.getNodePosition().toString() + ": ");
				for (int j = 0; j < Node.BUCKETS; j++) {
					if (tmpNode.getNeighbor(j) != null) {
						// fileOutput.print(tmpNode.getOutNeighbor(j).hashCode()+", ");
						fileOutput.print(tmpNode.getNeighbor(j)
								.getDistanceFrom(tmpNode)
								+ ", ");

					}
				}
				fileOutput.println();
			}
			fileOutput.close();
		} catch (IOException e) {
			System.err.println("Open graph.out ERROR!");
			e.printStackTrace();
		}

	}

	// ͳϢ1ڵھӸ2ڵھʱЧ
	public void stat() {
		int avgNeighborNum = 0, sumNeighborNum = 0, sumFailPercent = 0, avgFailPercent = 0;
		for (int i = 0; i < nodes.size(); i++) {
			sumNeighborNum += nodes.get(i).getNeighborNum();
			logger.info(i + "th node, neighbor number = "
					+ nodes.get(i).getNeighborNum() + ", durty degree = "
					+ nodes.get(i).getFailNum());
			sumFailPercent += nodes.get(i).getFailNum();
			for (int j = 0; j < Node.BUCKETS; j++) {
				if (nodes.get(i).getNeighbor(j) != null)
					logger.info(j + "th neighbor, position = "
							+ nodes.get(i).getNeighbor(j).getNodePosition());
			}
		}
		logger.info("ƽڵ = " + sumNeighborNum / nodes.size() + "ƽھʧЧ = "
				+ sumFailPercent / nodes.size());

	}

	public static void main(String[] argv) {
		PropertyConfigurator.configure("sort2.properties");
		// Graph graph = new Graph(64);
		// graph.addEdgesAccordingToDistance();

		Graph graph = new Graph();
		graph.initializeTheFirstNode(new Node());
		for (int i = 0; i < 1024; i++) {
			Node node = new Node();
			int messageNum = graph.addNode2(node);
			logger.info(i + "th node," + "messages: " + messageNum
					+ " neighbor number = " + node.getNeighborNum());

		}
		// graph.routingToAllNodesLessthanDistance2(graph.nodes.get(32),
		// Node.BUCKETS-1);
		graph.testRoute();
		graph.stat();
		// graph.delNodes();
		// graph.output("graph.out2");
		// System.out.println(graph.isOutNeighborNumEqualsInNeighborNum());

	}
}
